package de.ullisroboterseite.ursai2sensor;

import com.google.appinventor.components.common.Sensitivity;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.YailList;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;

import android.util.Log;
import android.view.Surface;
import android.view.WindowManager;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class Accelerometer extends SensorBase {
    // Zur Erkennung der Orientierung
    volatile int deviceDefaultOrientation;
    final WindowManager windowManager;
    final Resources resources;
    // Used to launch Runnables on the UI Thread after a delay
    final Handler androidUIHandler;

    public Accelerometer(UrsAI2Sensor ursAI2Sensor) {
        super(ursAI2Sensor, SensorType.Accelerometer, Sensor.TYPE_ACCELEROMETER);
        resources = ursAI2Sensor.thisForm.getResources();
        windowManager = (WindowManager) ursAI2Sensor.thisForm.getSystemService(Context.WINDOW_SERVICE);
        androidUIHandler = new Handler();
        androidUIHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                Accelerometer.this.deviceDefaultOrientation = getDeviceDefaultOrientation();
            }
        }, 32); // Wait 32ms for the UI to settle down
    }

    public int getDeviceDefaultOrientation() {
        try {
            if (Build.VERSION.SDK_INT < SdkLevel.LEVEL_FROYO) {
                // getRotation() is unavailable on versions of Android lower tha Froyo, so assume a default
                // orientation of PORTRAIT (which was the implied assumption before we added this check).
                return Configuration.ORIENTATION_PORTRAIT;
            }
            Configuration config = resources.getConfiguration();
            int rotation = windowManager.getDefaultDisplay().getRotation();

            if (((rotation == Surface.ROTATION_0 || rotation == Surface.ROTATION_180) &&
                    config.orientation == Configuration.ORIENTATION_LANDSCAPE)
                    || ((rotation == Surface.ROTATION_90 || rotation == Surface.ROTATION_270) &&
                            config.orientation == Configuration.ORIENTATION_PORTRAIT)) {
                return Configuration.ORIENTATION_LANDSCAPE;
            } else {
                return Configuration.ORIENTATION_PORTRAIT;
            }
        } catch (Exception e) {
            DebugUtil.LogExecption(e);
        }
        return Configuration.ORIENTATION_PORTRAIT;
    }

    @Override
    public void onStart(int argDelay, YailList control) {
        // nothing to do
    }

    @Override
    public void onStop() {
        // nothing to do
    }

    // SensorListener implementation
    @Override
    public void onSensorChanged(SensorEvent sensorEvent) {
        try {
            final float[] values = sensorEvent.values;
            // make landscapePrimary devices report acceleration as if they were
            // portraitPrimary
            if (deviceDefaultOrientation == Configuration.ORIENTATION_LANDSCAPE) {
                float temp = values[0];
                values[0] = values[1];
                values[1] = -values[0];
            }

            List<Float> valueList = new ArrayList<>();
            for (Float val : values) {
                valueList.add(val);
            }
            reportSensorData(sensorType, valueList, sensorEvent.accuracy);
        } catch (Exception e) {
            DebugUtil.LogExecption(e);
        }
    }
}
