package de.ullisroboterseite.ursai2sensor;

import com.google.appinventor.components.common.Sensitivity;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.YailList;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;

import android.util.Log;
import android.view.Surface;
import android.view.WindowManager;
import android.hardware.SensorEventListener;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class MagneticFieldSensor extends SensorBase {
    UrsAI2Sensor ursAI2Sensor; // Instance of the extension, e.g. for triggering events.

    public MagneticFieldSensor(UrsAI2Sensor ursAI2Sensor) {
        super(ursAI2Sensor, SensorType.MagneticField, Sensor.TYPE_MAGNETIC_FIELD);
        this.ursAI2Sensor = ursAI2Sensor;
    }

    @Override
    public void onStart(int argDelay, YailList control) {
        // nothing to do
    }

    @Override
    public void onStop() {
        // nothing to do
    }

    // SensorListener implementation
    @Override
    public void onSensorChanged(SensorEvent sensorEvent) {
        List<Float> valueList = new ArrayList<>();
        for (Float val : sensorEvent.values) {
            valueList.add(val);
        }

        float absoluteStrength = (float) Math.sqrt((double) (((sensorEvent.values[0] * sensorEvent.values[0])
                + (sensorEvent.values[1] * sensorEvent.values[1])) + (sensorEvent.values[2] * sensorEvent.values[2])));

        valueList.add(absoluteStrength);

        reportSensorData(sensorType, valueList, sensorEvent.accuracy);
    }
}
