package de.ullisroboterseite.ursai2sensor;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.util.Log;

public class SensorListener implements SensorEventListener {
    static final public String LOG_TAG = UrsAI2Sensor.LOG_TAG;
    SensorBase sensor; // Instance of the extension, e.g. for triggering events.

    public SensorListener(SensorBase sensor) {
        this.sensor = sensor;
    }

    // Forward event.
    @Override
    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensor != null) {
            sensor.onSensorChanged(sensorEvent);
        }
    }

        @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}
