package de.ullisroboterseite.ursai2sensor;

import com.google.appinventor.components.annotations.*;
import com.google.appinventor.components.annotations.androidmanifest.*;
import com.google.appinventor.components.common.*;
import com.google.appinventor.components.runtime.*;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.ErrorMessages;

import java.util.LinkedList;
import java.util.Queue;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ServiceInfo;

import android.app.Service;
import android.app.Notification;

import android.os.Binder;
import android.os.IBinder;
import android.os.Build;
import android.os.PowerManager;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;

import androidx.core.app.NotificationManagerCompat;

import android.util.Log;

// https://gist.github.com/julian-ramos/6ee7ad8a74ee4b442530

@SimpleObject()
public class SensorService extends Service implements SensorEventListener {
    static final String LOG_TAG = UrsAI2Sensor.LOG_TAG;

    public class LocalBinder extends Binder {
        public SensorService getService() {
            return SensorService.this;
        }
    }

    String ChannelID = "SensorChannel";
    String screenToOpen = "Screen1";
    int notificationID = 13777;
    Binder binder = new LocalBinder();

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d(LOG_TAG, "SensorService.onStartCommand");

        try {
            int notificationID = intent.getIntExtra("NotificationID", -1);
            Notification notification = Util.CreateNotification(this //
                    , intent.getStringExtra("ChannelID") //
                    , intent.getStringExtra("Title") //
                    , intent.getStringExtra("Text") //
                    , intent.getStringExtra("SmallIconPath") //
                    , intent.getIntExtra("Icon", 1) //
                    , intent.getStringExtra("ClassName")//
                    , intent.getStringExtra("StartValue") //
                    , intent.getStringExtra("LargeIconPath")//
                    , notificationID //
                    , intent.getBooleanExtra ("Deletable", false)//
                    , intent.getStringExtra("Action1")//
                    , intent.getStringExtra("Action2")//
                    , intent.getStringExtra("Action3"));
            Log.d(LOG_TAG, "Service: create notification, ID: " + notificationID);

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                startForeground(notificationID, notification,
                        ServiceInfo.FOREGROUND_SERVICE_TYPE_MEDIA_PLAYBACK);
            } else {
                startForeground(notificationID, notification);
            }
        } catch (Exception e) {
            DebugUtil.LogExecption("In Service onStartCommand", e);
            UrsAI2Sensor.thisInstance.thisForm.ErrorOccurred(UrsAI2Sensor.thisInstance,
                    "onStartCommand", 17093, "In Service onStartCommand: " + e.toString());
        }
        return START_NOT_STICKY;
    }

    @Override
    public void onDestroy() {
        Log.d(LOG_TAG, "SensorService: destroy");
        super.onDestroy();
    }

    @Override
    public IBinder onBind(Intent intent) {
        return binder;
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    // Forward event.
    @Override
    public void onSensorChanged(SensorEvent sensorEvent) {
    }
}