package de.ullisroboterseite.ursai2sensor;

import java.util.HashMap;
import java.util.Map;
import com.google.appinventor.components.common.*;

// Defines a Accuracy type used by the UrsAI2Sensor extension.
public enum Accuracy implements OptionList<Integer> {
    Meaningless(0),
    Low(1),
    Medium(2),
    High(3);

    private final int value;

    Accuracy(int accuracy) {
        this.value = accuracy;
    }

    public Integer toUnderlyingValue() {
        return value;
    }

    private static final Map<Integer, Accuracy> lookup = new HashMap<>();

    static {
        for (Accuracy accuracy : Accuracy.values()) {
            lookup.put(accuracy.toUnderlyingValue(), accuracy);
        }
    }

    public static Accuracy fromUnderlyingValue(Integer accuracy) {
        return lookup.get(accuracy);
    }
}