package de.ullisroboterseite.ursai2sensor;

import java.util.HashMap;
import java.util.Map;
import com.google.appinventor.components.common.*;

// Defines the Importance for the notification channel extension.
public enum Importance implements OptionList<Integer> {
    Default(3),
    Max(5),
    High(4),
    Low(2),
    Min(1),
    None(0);

    private final int value;

    Importance(int importance) {
        this.value = importance;
    }

    public Integer toUnderlyingValue() {
        return value;
    }

    private static final Map<Integer, Importance> lookup = new HashMap<>();

    static {
        for (Importance importance : Importance.values()) {
            lookup.put(importance.toUnderlyingValue(), importance);
        }
    }

    public static Importance fromUnderlyingValue(Integer importance) {
        return lookup.get(importance);
    }
}