package de.ullisroboterseite.ursai2sensor;

import java.util.HashMap;
import java.util.Map;
import com.google.appinventor.components.common.*;

// Defines a SensorType type used by the UrsAI2Sensor extension.
public enum SensorType implements OptionList<Integer> {
  Accelerometer(1),
  ShakingSensor(2),
  MagneticField(3),
  OrientationSensor(4);

  private final int value;

  SensorType(int sensorType) {
    this.value = sensorType;
  }

  public Integer toUnderlyingValue() {
    return value;
  }

  private static final Map<Integer, SensorType> lookup = new HashMap<>();

  static {
    for (SensorType sensorType : SensorType.values()) {
      lookup.put(sensorType.toUnderlyingValue(), sensorType);
    }
  }

  public static SensorType fromUnderlyingValue(Integer sensorType) {
    return lookup.get(sensorType);
  }
}
