package de.ullisroboterseite.ursai2sensorutil;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;

import androidx.core.graphics.drawable.IconCompat;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationCompat.Builder;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.app.NotificationChannelCompat;

import android.app.PendingIntent;
import android.app.Notification;

import android.os.Build;
import android.os.Environment;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.Html;

import android.util.Log;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.swing.Action;

import com.google.appinventor.components.runtime.util.YailList;

public class Util {

    static final String LOG_TAG = UrsAI2SensorUtil.LOG_TAG;

    static Map<String, Integer> IconIds = new HashMap<String, Integer>() {
        static final long serialVersionUID = 1L;
        {
            put("alert_dark_frame", 17301504); //
            put("alert_light_frame", 17301505); //
            put("arrow_down_float", 17301506); //
            put("arrow_up_float", 17301507); //
            put("bottom_bar", 17301658); //
            put("btn_default", 17301508); //
            put("btn_default_small", 17301509); //
            put("btn_dialog", 17301527); //
            put("btn_dropdown", 17301510); //
            put("btn_minus", 17301511); //
            put("btn_plus", 17301512); //
            put("btn_radio", 17301513); //
            put("btn_star", 17301514); //
            put("btn_star_big_off", 17301515); //
            put("btn_star_big_on", 17301516); //
            put("button_onoff_indicator_off", 17301518); //
            put("button_onoff_indicator_on", 17301517); //
            put("checkbox_off_background", 17301519); //
            put("checkbox_on_background", 17301520); //
            put("dark_header", 17301521); //
            put("dialog_frame", 17301521); //
            put("dialog_holo_dark_frame", 17301682); //
            put("dialog_holo_light_frame", 17301683); //
            put("divider_horizontal_bright", 17301522); //
            put("divider_horizontal_dark", 17301524); //
            put("divider_horizontal_dim_dark", 17301525); //
            put("divider_horizontal_textfield", 17301523); //
            put("edit_text", 17301526); //
            put("editbox_background", 17301528); //
            put("editbox_background_normal", 17301529); //
            put("editbox_dropdown_dark_frame", 17301530); //
            put("editbox_dropdown_light_frame", 17301531); //
            put("gallery_thumb", 17301532); //
            put("ic_btn_speak_now", 17301668); //
            put("ic_delete", 17301533); //
            put("ic_dialog_alert", 17301543); //
            put("ic_dialog_dialer", 17301544); //
            put("ic_dialog_email", 17301545); //
            put("ic_dialog_info", 17301659); //
            put("ic_dialog_map", 17301546); //
            put("ic_input_add", 17301547); //
            put("ic_input_delete", 17301548); //
            put("ic_input_get", 17301549); //
            put("ic_lock_idle_alarm", 17301550); //
            put("ic_lock_idle_charging", 17301534); //
            put("ic_lock_idle_lock", 17301535); //
            put("ic_lock_idle_low_battery", 17301536); //
            put("ic_lock_lock", 17301551); //
            put("ic_lock_power_off", 17301552); //
            put("ic_lock_silent_mode", 17301553); //
            put("ic_lock_silent_mode_off", 17301554); //
            put("ic_media_ff", 17301537); //
            put("ic_media_next", 17301538); //
            put("ic_media_pause", 17301539); //
            put("ic_media_play", 17301540); //
            put("ic_media_previous", 17301541); //
            put("ic_media_rew", 17301542); //
            put("ic_menu_add", 17301555); //
            put("ic_menu_agenda", 17301556); //
            put("ic_menu_always_landscape_portrait", 17301557); //
            put("ic_menu_call", 17301558); //
            put("ic_menu_camera", 17301559); //
            put("ic_menu_close_clear_cancel", 17301560); //
            put("ic_menu_compass", 17301561); //
            put("ic_menu_crop", 17301562); //
            put("ic_menu_day", 17301563); //
            put("ic_menu_delete", 17301564); //
            put("ic_menu_directions", 17301565); //
            put("ic_menu_edit", 17301566); //
            put("ic_menu_gallery", 17301567); //
            put("ic_menu_help", 17301568); //
            put("ic_menu_info_details", 17301569); //
            put("ic_menu_manage", 17301570); //
            put("ic_menu_mapmode", 17301571); //
            put("ic_menu_month", 17301572); //
            put("ic_menu_more", 17301573); //
            put("ic_menu_my_calendar", 17301574); //
            put("ic_menu_mylocation", 17301575); //
            put("ic_menu_myplaces", 17301576); //
            put("ic_menu_preferences", 17301577); //
            put("ic_menu_recent_history", 17301578); //
            put("ic_menu_report_image", 17301579); //
            put("ic_menu_revert", 17301580); //
            put("ic_menu_rotate", 17301581); //
            put("ic_menu_save", 17301582); //
            put("ic_menu_search", 17301583); //
            put("ic_menu_send", 17301584); //
            put("ic_menu_set_as", 17301585); //
            put("ic_menu_share", 17301586); //
            put("ic_menu_slideshow", 17301587); //
            put("ic_menu_sort_alphabetically", 17301660); //
            put("ic_menu_sort_by_size", 17301661); //
            put("ic_menu_today", 17301588); //
            put("ic_menu_upload", 17301589); //
            put("ic_menu_upload_you_tube", 17301590); //
            put("ic_menu_view", 17301591); //
            put("ic_menu_week", 17301592); //
            put("ic_menu_zoom", 17301593); //
            put("ic_notification_clear_all", 17301594); //
            put("ic_notification_overlay", 17301595); //
            put("ic_partial_secure", 17301596); //
            put("ic_popup_disk_full", 17301597); //
            put("ic_popup_reminder", 17301598); //
            put("ic_popup_sync", 17301599); //
            put("ic_search_category_default", 17301600); //
            put("ic_secure", 17301601); //
            put("list_selector_background", 17301602); //
            put("menu_frame", 17301603); //
            put("menu_full_frame", 17301604); //
            put("menuitem_background", 17301605); //
            put("picture_frame", 17301606); //
            put("presence_audio_away", 17301679); //
            put("presence_audio_busy", 17301680); //
            put("presence_audio_online", 17301681); //
            put("presence_away", 17301607); //
            put("presence_busy", 17301608); //
            put("presence_invisible", 17301609); //
            put("presence_offline", 17301610); //
            put("presence_online", 17301611); //
            put("presence_video_away", 17301676); //
            put("presence_video_busy", 17301677); //
            put("presence_video_online", 17301678); //
            put("progress_horizontal", 17301612); //
            put("progress_indeterminate_horizontal", 17301613); //
            put("radiobutton_off_background", 17301614); //
            put("radiobutton_on_background", 17301615); //
            put("screen_background_dark", 17301656); //
            put("screen_background_dark_transparent", 17301673); //
            put("screen_background_light", 17301657); //
            put("screen_background_light_transparent", 17301674); //
            put("spinner_background", 17301616); //
            put("spinner_dropdown_background", 17301617); //
            put("star_big_off", 17301619); //
            put("star_big_on", 17301621); //
            put("star_off", 17301618); //
            put("star_on", 17301620); //
            put("stat_notify_call_mute", 17301622); //
            put("stat_notify_chat", 17301623); //
            put("stat_notify_error", 17301624); //
            put("stat_notify_missed_call", 17301631); //
            put("stat_notify_more", 17301625); //
            put("stat_notify_sdcard", 17301626); //
            put("stat_notify_sdcard_prepare", 17301675); //
            put("stat_notify_sdcard_usb", 17301627); //
            put("stat_notify_sync", 17301628); //
            put("stat_notify_sync_noanim", 17301629); //
            put("stat_notify_voicemail", 17301630); //
            put("stat_sys_data_bluetooth", 17301632); //
            put("stat_sys_download", 17301633); //
            put("stat_sys_download_done", 17301634); //
            put("stat_sys_headset", 17301635); //
            put("stat_sys_phone_call", 17301636); //
            put("stat_sys_phone_call_forward", 17301637); //
            put("stat_sys_phone_call_on_hold", 17301638); //
            put("stat_sys_speakerphone", 17301639); //
            put("stat_sys_upload", 17301640); //
            put("stat_sys_upload_done", 17301641); //
            put("stat_sys_vp_phone_call", 17301671); //
            put("stat_sys_vp_phone_call_on_hold", 17301672); //
            put("stat_sys_warning", 17301642); //
            put("status_bar_item_app_background", 17301643); //
            put("status_bar_item_background", 17301644); //
            put("sym_action_call", 17301645); //
            put("sym_action_chat", 17301646); //
            put("sym_action_email", 17301647); //
            put("sym_call_incoming", 17301648); //
            put("sym_call_missed", 17301649); //
            put("sym_call_outgoing", 17301650); //
            put("sym_contact_card", 17301652); //
            put("sym_def_app_icon", 17301651); //
            put("title_bar", 17301653); //
            put("title_bar_tall", 17301670); //
            put("toast_frame", 17301654); //
            put("zoom_plate", 17301655); //
        }
    };

    static int getSystemIcon(String iconName, Context context) {
        Integer id = null;
        iconName = iconName.trim();
        if (iconName.startsWith("android.R.drawable."))
            iconName = iconName.substring(19);
        if (iconName == "ic_launcher") {
            id = context.getApplicationInfo().icon;
        } else {
            id = IconIds.get(iconName);
        }

        Log.d(LOG_TAG, "System icon request, name: " + iconName + " id: " + id);
        if (id == null)
            return 17301653; // 17301653, title_bar dunkles Quadrat
        return id;
    }

    // Legt den Kanal neu an bzw. ändert die Parameter, wenn er bereits existiert.
    public static void createChannel(Context context, String id, String name, String description, int importance) {
        NotificationManagerCompat manager = NotificationManagerCompat.from(context);
        NotificationChannelCompat channel = new NotificationChannelCompat.Builder(id, importance)
                .setName(name)
                .setDescription(description)
                .setSound(null, null)
                .build();

        // manager is of type NotificationManagerCompat
        manager.createNotificationChannel(channel);
        Log.d(LOG_TAG, "Channel created ID: " + id + " Name: " + name);
    }

    // context:          Der zur App gehörende Context (= form).
    // channelID:        Die ID des Channels unter dem die Notification angelegt werden soll.
    // title:            Der Notification-Titel.
    // text:             Der Notification-Text.
    // smallIconPath:    Pfad auf eine Asset-Datei. Hat Vorrang vor 'notificationIcon'.
    // notificationIcon: Name eines System Notification Icons    https://ullisroboterseite.de/android-AI2-KeepAwake.html#icon.
    // className:        leer: keine Aktion, Name eines Screens: Der Screen wird geöffnet,
    // .                 vollständiger Name einer Activity (PackageName + ClassName): Start der Activity.
    // startValue:       Intent.Extra, wenn das Ziel des Intents ein Screen der App ist.
    // largeIconPath:    Pfad auf eine Asset-Datei.
    // notificationID:   ID der Notification.
    // deletable:        Die Notification kann vom Anwender gelöscht werden.
    public static Notification CreateNotification(Context context, String channelID, String title, String text,
            String smallIconPath, int notificationIcon, String className, String startValue, String largeIconPath,
            int notificationID, boolean deletable, String action1Title, String action2Title, String action3Title) {

        Log.d(LOG_TAG, "createNotification, smallIconPath: " + smallIconPath + " notificationIcon: " + notificationIcon
                + " ChannelID: " + channelID);

        Intent notificationIntent = null;
        PendingIntent clickIntent = null;

        if (!className.isEmpty()) {
            try {
                Log.d(LOG_TAG, "className: " + className);
                notificationIntent = new Intent(context, Class.forName(className));
            } catch (Exception e) {
                Log.d(LOG_TAG, "Klasse nicht gefunden:" + className);
            }

            notificationIntent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);

            if (notificationIntent != null) {
                notificationIntent.putExtra("APP_INVENTOR_START", startValue);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
                    clickIntent = PendingIntent.getActivity(context, 0, notificationIntent,
                            PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_IMMUTABLE);
                else
                    clickIntent = PendingIntent.getActivity(context, 0, notificationIntent, 0);
            }
        }

        NotificationCompat.Builder nb = new NotificationCompat.Builder(context, channelID);

        SpannableString spannedTitle = new SpannableString(Html.fromHtml(title));
        nb.setContentTitle(spannedTitle);

        SpannableString spannedText = new SpannableString(Html.fromHtml(text));
        nb.setContentText(spannedText);

        nb.setShowWhen(false);
        nb.setOngoing(!deletable);

        IconCompat icon = null;
        if (!smallIconPath.isEmpty()) {
            Log.d(LOG_TAG, "try smallIconPath: " + smallIconPath);
            Bitmap iconBitmap = getBitmap(context, smallIconPath);
            icon = IconCompat.createWithBitmap(iconBitmap);
        }
        if (icon == null) {
            Log.d(LOG_TAG, "CreateNotification: from symbol");
            nb.setSmallIcon(notificationIcon);
        } else {
            Log.d(LOG_TAG, "CreateNotification: from icon");
            nb.setSmallIcon(icon);
        }

        if (!largeIconPath.isEmpty()) {
            nb.setLargeIcon(Util.getBitmap(context, largeIconPath));
            Log.d(LOG_TAG, "Large icon set: " + largeIconPath);
        }

        nb.setContentIntent(clickIntent);

        Intent deleteIntent = new Intent(UrsAI2SensorUtil.DELETE_TAG);
        deleteIntent.putExtra(UrsAI2SensorUtil.NOTIFICATION_ID_TAG, notificationID);

        PendingIntent peDelete;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
            peDelete = PendingIntent.getBroadcast(context, 0, deleteIntent,
                    PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_IMMUTABLE);
        else
            peDelete = PendingIntent.getBroadcast(context, 0, deleteIntent, PendingIntent.FLAG_UPDATE_CURRENT);

        nb.setDeleteIntent(peDelete);

        if (!action1Title.isEmpty()) {
            PendingIntent pe = getClickPendingIntent(context, notificationID, 1);
            SpannableString spannedActionTitle = new SpannableString(Html.fromHtml(action1Title));
            nb.addAction(0, spannedActionTitle, pe); //Kein Icon. Icon wird nur bei älteren Versionen unterstützt
        }

        if (!action2Title.isEmpty()) {
            PendingIntent pe = getClickPendingIntent(context, notificationID, 2);
            SpannableString spannedActionTitle = new SpannableString(Html.fromHtml(action2Title));
            nb.addAction(0, spannedActionTitle, pe); //Kein Icon. Icon wird nur bei älteren Versionen unterstützt
        }

          if (!action3Title.isEmpty()) {
            PendingIntent pe = getClickPendingIntent(context, notificationID, 3);
            SpannableString spannedActionTitle = new SpannableString(Html.fromHtml(action3Title));
            nb.addAction(0, spannedActionTitle, pe); //Kein Icon. Icon wird nur bei älteren Versionen unterstützt
        }      

        Notification notification = nb.build();
        notification.flags += Notification.FLAG_NO_CLEAR + Notification.FLAG_INSISTENT
                + Notification.FLAG_ONLY_ALERT_ONCE;
        if (!deletable)
            notification.flags += +Notification.FLAG_ONGOING_EVENT;
        Log.d(LOG_TAG, "Notification created");
        return notification;
    }

    public static Bitmap getBitmap(Context context, String filePath) {
        Bitmap bitmap = null;
        if (filePath.contains("/sdcard/")) {
            Log.d(LOG_TAG, "getBitmap from file");
            File sd = Environment.getExternalStorageDirectory();
            filePath.replace("/sdcard/", (new StringBuilder()).append(sd).append("/").toString());
            File image = new File(filePath);
            bitmap = BitmapFactory.decodeFile(image.getAbsolutePath());
        } else {
            Log.d(LOG_TAG, "getBitmap from asset");
            AssetManager assetManager = context.getAssets();
            try {
                java.io.InputStream istr = assetManager.open(filePath);
                bitmap = BitmapFactory.decodeStream(istr);
            } catch (IOException ioexception) {
                DebugUtil.LogExecption("getBitmap", ioexception);
            }
        }
        return bitmap;
    }

    // Führt dazu, dass die Notification-Seite geschlossen und die letzte App wieder angezeigt wird
    static PendingIntent getGoBackPendingIntent(Context context, int intendId) {
        Log.d(LOG_TAG, "getGoBackPendingIntent GoBack ID: " + intendId);

        Intent intent = new Intent();

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
            return PendingIntent.getActivity(context, intendId, intent,
                    PendingIntent.FLAG_IMMUTABLE);
        else
            return PendingIntent.getActivity(context, intendId, intent, 0);
    }

    static PendingIntent getClickPendingIntent(Context context, int notificationID, int actionID) {
        Intent intent = new Intent(UrsAI2SensorUtil.NOTIFICATION_EVENT_TAG);
        intent.putExtra(UrsAI2SensorUtil.NOTIFICATION_ID_TAG, notificationID);
        intent.putExtra(UrsAI2SensorUtil.ACTION_ID_TAG, actionID);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
            return PendingIntent.getBroadcast(context, actionID, intent, PendingIntent.FLAG_IMMUTABLE);
        else
            return PendingIntent.getBroadcast(context, actionID, intent, 0);
    }
}