// Decoder.h

#pragma once

#include <Arduino.h>
#include <esp32-hal-rmt.h>

// Mgliche Fehlercodes des IR-Decoders
enum class DecoderErrorCodes {
   Success,                // Die Symbolfolge konnte erfolgreich dekodiert werden
   InvalidNumberOfSymbols, // Die erwartete Anzahl an Symbolen stimmt nicht
   InvalidSymbolDuration,  // Die erwartete Dauer der Pulse stimmt nicht
};

// Rckegabewert des Decoders
class DecoderResult {
public:
   DecoderErrorCodes ReturnCode; 
   uint32_t IrCode; // Ermittelter Code
   const char* Type; // Typ der Fernbedienung

   DecoderResult(DecoderErrorCodes ReturnCode, uint32_t IrCode, const char * Type) : ReturnCode(ReturnCode), IrCode(IrCode), Type(Type) {}

   // Liefert true, wenn die Decodierung erfolgreich war
   operator bool() const { return ReturnCode == DecoderErrorCodes::Success; }
};

// Basisklasse fr IR-Decoder
// Die Klasse dient als Interface
class RmtDecoder {
public:
   RmtDecoder() {}
   virtual DecoderResult decode(rmt_data_t* data, size_t data_symbols) = 0;
   virtual ~RmtDecoder() {}
};