#include "RmtMetzRM18Decoder.h"

DecoderResult RmtMetzRM18Decoder::decode(rmt_data_t* data, size_t data_symbols) {
   uint32_t code = 0;

   if (data_symbols != expectedSymbols)
      return DecoderResult(DecoderErrorCodes::InvalidNumberOfSymbols, 0, Type);

   if (data[0].duration0 < 800 || data[0].duration0 > 1100)
      return DecoderResult(DecoderErrorCodes::InvalidSymbolDuration, 0, Type);
   if (data[0].duration1 < 2000 || data[0].duration1 > 2500)
      return DecoderResult(DecoderErrorCodes::InvalidSymbolDuration, 0, Type);

   for (int i = 1; i < data_symbols - 1; i++) {
      if (data[i].duration0 < 450 || data[i].duration0 > 550)
         return DecoderResult(DecoderErrorCodes::InvalidSymbolDuration, 0, Type);
      code = code << 1;
      if (data[i].duration1 < 1100) // Mark
         code += 1;
      else
         ; // Space
   }
   return DecoderResult(DecoderErrorCodes::Success, code, Type);
}
