#include "RmtToshibaSER0336Decoder.h"

DecoderResult RmtToshibaSER0336Decoder::decode(rmt_data_t* data, size_t data_symbols) {
   uint32_t code = 0;

   if (data_symbols != expectedSymbols)
      return DecoderResult(DecoderErrorCodes::InvalidNumberOfSymbols, 0, Type);

   if (data[0].duration0 < 8900 || data[0].duration0 > 9500)
      return DecoderResult(DecoderErrorCodes::InvalidSymbolDuration, 0, Type);
   if (data[0].duration1 < 4000 || data[0].duration1 > 5000)
      return DecoderResult(DecoderErrorCodes::InvalidSymbolDuration, 0, Type);

   for (int i = 1; i < data_symbols - 1; i++) {
      if (data[i].duration0 < 600 || data[i].duration0 > 700)
         return DecoderResult(DecoderErrorCodes::InvalidSymbolDuration, 0, Type);
      code = code << 1;
      if (data[i].duration1 < 1000) // Mark
         code += 1;
      else
         ; // Space
   }
   return DecoderResult(DecoderErrorCodes::Success, code, Type);
}
