#include <UrsEsp.h>
#include <esp32-hal-rmt.h>
#include "AppVersion.h"

constexpr uint8_t RMT_GPIO = 10; // Pin, an den der IR-Empfnger angeschlossen ist

rmt_data_t data[50];             // Feld zur Aufnahme der empfangenen Symbole
size_t data_symbols = RMT_SYMBOLS_OF(data); // Gre des Datenfeldes

constexpr uint16_t rxMaxThreshold = 32'767; // Maximal mglicher Wert (RMT_LL_MAX_IDLE_VALUE in rmt_ll.h)
constexpr uint16_t rxMinThreshold = 3;      // Max. Wert => 3'000 ns (Max ist 3187 ns)

void setup() {
   Serial.begin(115200);
   delay(1000); // Zeit zum Setup des Serial-Terminal
   Serial.printf("\n%s Version %s by %s\n", APP_NAME, APP_VERSION, APP_AUTHOR);
   Serial.println(APP_WEBSITE);

   auto resetReason = UrsCPU::UrsESP.getResetReason(0);
   Serial.printf("CPU0 reset reason: %i (%s) %s\n", resetReason, UrsCPU::UrsESP.getResetReasonName(resetReason).c_str(), UrsCPU::UrsESP.getResetReasonDescription(resetReason).c_str());

   // Wenn nicht Power-On-Reset dann stoppen.
   if (resetReason != 1) { // Ansonsten erfolgt dauernd ein neuer Reset
      Serial.println("Programm angehalten");
      while (1);
   }

   Serial.print("IR Idle-Level: "); Serial.println(digitalRead(RMT_GPIO));

   if (!rmtInit(RMT_GPIO, RMT_RX_MODE, RMT_MEM_NUM_BLOCKS_1, 1'000'000)) {
      Serial.println("Initialisierung des Receivers fehlgeschlagen\nPogramm angehalten\n");
      while (1);
   }
   Serial.println("RMT-Taktzeit auf 1 us festgelegt");

   if (rmtSetRxMaxThreshold(RMT_GPIO, rxMaxThreshold))
      Serial.printf("RxMaxThreshold auf %u festgelegt\n", rxMaxThreshold);
   else
      Serial.printf("%u ist fr RxMaxThreshold ungltig\n", rxMaxThreshold);

   if (rmtSetRxMinThreshold(RMT_GPIO, rxMinThreshold))
      Serial.printf("RxMinThreshold auf %u festgelegt\n", rxMinThreshold);
   else
      Serial.printf("%u ist fr RxMinThreshold ungltig\n", rxMinThreshold);
   Serial.println("\nBereit zum Empfang");
}

void loop() {
   data_symbols = RMT_SYMBOLS_OF(data); // data_symbols wurde beim Lesen verndert

   // Wenn Daten gelesen wurden, enthlt data_symbols die Anzahl der tatschlich gelesenen RMT - Symbole.
   // Um zu berprfen, ob etwas gelesen wurde oder zu einer Zeitberschreitung gekommen ist,
   // kann rmtReceiveCompleted() verwendet werden.
   rmtRead(RMT_GPIO, data, &data_symbols, 500);

   // Wenn etwas gelesen wurde, Daten verarbeiten.
   if (rmtReceiveCompleted(RMT_GPIO)) {
      Serial.printf("%i symbols\n", data_symbols);
      for (size_t i = 0; i < data_symbols; i++)
         Serial.printf("%4i\t%4i\n", data[i].duration0, data[i].duration1);
   }

   // Wegen Bug (?) im Modul ist nach jedem Lesen eine neue Initialisierung notwendig. Sonst:
   // E (28028) rmt: rmt_receive(401): channel not in enable state
   rmtDeinit(RMT_GPIO);
   rmtInit(RMT_GPIO, RMT_RX_MODE, RMT_MEM_NUM_BLOCKS_1, 1'000'000);
   rmtSetRxMaxThreshold(RMT_GPIO, rxMaxThreshold);
   rmtSetRxMinThreshold(RMT_GPIO, rxMinThreshold);
}