#pragma once

#include <Arduino.h>
#include <WiFiUdp.h>

// Define the callback function type for processing commands
typedef void (*ProcessCommand_t)(const char command, const int data1, const int data2);

// UDP Handler class
class UdpHandler {
public:
   // Constructor with local and remote ports
   UdpHandler(uint16_t localPort, uint16_t remotePort) {
      this->localPort = localPort;
      this->remotePort = remotePort;
   }

   // Initialize the UDP handler
   void begin();

   // Handle incoming UDP packets
   void handleUdp();

   // Set the callback function to process commands
   void setCommandCallback(ProcessCommand_t callback) {
      processCommand = callback;
   }

protected:
   WiFiUDP udp;  // Create a UDP instance
   char packetBuffer[255]; // buffer to hold incoming packet
   char lastmessage[255];  // buffer to hold last message

   uint16_t localPort; // local port to listen on
   uint16_t remotePort; // remote port to send to
   ProcessCommand_t processCommand; // Callback function to process commands
};
